#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	/// <summary>
	/// Summary description for TransfusionEffectivenessReport.
	/// </summary>
	[TestFixture]
	public class BOL_TransfusionEffectivenessReport : BaseTest 
	{
		private BOL.TransfusionEffectivenessReport _report;
		private Guid _patientGuid;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			string sb = "SELECT TOP 1 "+TABLES.Patient.PatientGuid+" FROM Patient ORDER BY "+TABLES.Patient.LastUpdateDate+Common.Utility.DescSortOrderSuffix;

			this._patientGuid = DataCreator.GetRecordGuid(sb.ToString());

			_report = new BOL.TransfusionEffectivenessReport();
			_report.SetInitialBrokenRules("DlgTransfusionEffectivenessReportCriteria");
		}	

#region constructors

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(_report != null);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Fail()
		{
		}


#endregion

#region properties

		[Test]
		public void IsAllPatient_Get()
		{
			Assert.IsTrue(_report.IsAllPatients);
		}

		[Test]
		public void IsAllPatient_Pass()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			_report.IsAllPatients = false;
			brokenRulesBefore = _report.BrokenRulesCount;
			_report.IsAllPatients = true;
			brokenRulesAfter = _report.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		public void IsAllPatient_Fail()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			_report.IsAllPatients = true;
			brokenRulesBefore = _report.BrokenRulesCount;
			_report.IsAllPatients = false;
			brokenRulesAfter = _report.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter>brokenRulesBefore);
		}

		[Test]
		public void Patient_Get()
		{
			_report.IsAllPatients = false;
			_report.Patient = new BOL.Patient(_patientGuid);
			Assert.IsNotNull(_report.Patient);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void Patient_Get_Fail()
		{
			Assert.IsNotNull(_report.Patient);
		}

		[Test]
		public void Patient_Pass()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			_report.IsAllPatients = false;
			brokenRulesBefore = _report.BrokenRulesCount;
			_report.IsAllPatients = false;
			_report.Patient = new BOL.Patient(_patientGuid);
			brokenRulesAfter = _report.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		public void Patient_Fail()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			_report.IsAllPatients = false;
			_report.Patient = new BOL.Patient(_patientGuid);
			brokenRulesBefore = _report.BrokenRulesCount;
			_report.IsAllPatients = false;
			_report.Patient = new BOL.Patient();
			brokenRulesAfter = _report.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter>brokenRulesBefore);
		}

		[Test]
		public void DetailedReport_Get()
		{
			try
			{
				VistALinkUnitTestHarness.RequireConnection();

				_report.StartDate = DateTime.Now.AddYears(-1);
				Assert.IsNotNull(_report.DetailedReport);
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void DetailedReport_Set()
		{
		}

		[Test]
		public void ReportCriteria_Get()
		{
			Assert.IsNotNull(_report.ReportCriteria);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ReportCriteria_Set()
		{
		}

#endregion


#region methods

		[Test]
		public void GetTransfusionEffectivenessReport_Pass()
		{
			_report.StartDate = DateTime.Now.AddYears(-1);
			_report.GetTransfusionEffectivenessReport();
			Assert.IsNotNull(_report.DetailedReport);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionEffectivenessReport_Fail()
		{
		}

		[Test]
		public void GenerateReport_Pass()
		{
			/*gov.va.med.vbecs.reports.TransfusionEffectiveness.TransfusionEffectivenessReport mainReport = 
				this._report.GenerateReport( UnitTestConfig.User_AdministratorSupervisor );  
			//
			Assert.IsNotNull( mainReport );*/
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateReport_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report directly to the printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report directly to the printer
		}

#endregion
	}
}

#endif
